<?php include 'includes/header.php'; ?>

<!-- MUSIC SECTION -->
<section id="music" class="section relative min-h-screen flex items-center justify-center p-6 bg-void-black pt-24">
    <div class="max-w-7xl w-full text-center relative z-10">
        <h1 class="glitch text-6xl font-black font-oswald text-transparent bg-clip-text bg-gradient-to-r from-neon-purple to-hot-pink mb-6 inline-block"
            data-text="Music">
            Music
        </h1>
        <p class="text-xl max-w-3xl mx-auto mb-12 text-silver">
            Where logic meets emotion. Through the guitar, I tell stories without words.
        </p>

        <!-- 3D Waveform Container -->
        <div id="waveform-container" class="h-[400px] w-full mb-12 relative"></div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="glass-box p-6 rounded-2xl hover:glow-purple transition-all">
                <h3 class="text-neon-purple font-bold mb-3 text-xl">🎸 Genres</h3>
                <p class="text-sm text-silver">Rock, Blues, Acoustic, Ambient</p>
            </div>
            <div class="glass-box p-6 rounded-2xl hover:glow-purple transition-all">
                <h3 class="text-neon-purple font-bold mb-3 text-xl">🎵 Instruments</h3>
                <p class="text-sm text-silver">Electric Guitar, Acoustic Guitar, Bass</p>
            </div>
            <div class="glass-box p-6 rounded-2xl hover:glow-purple transition-all">
                <h3 class="text-neon-purple font-bold mb-3 text-xl">🎼 Experience</h3>
                <p class="text-sm text-silver">Composer, Session Musician, Producer</p>
            </div>
        </div>

        <div class="mt-12">
            <a href="https://soundcloud.com" target="_blank"
                class="text-neon-purple hover:underline text-lg font-oswald tracking-widest">LISTEN ON SOUNDCLOUD ↗</a>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>