<!DOCTYPE html>
<html lang="en" class="scroll-smooth">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ashishxmani — Guitarist, DevOps Engineer, Entrepreneur</title>
    <link rel="icon" type="image/svg+xml" href="assets/images/favicon.svg">
    <meta name="description"
        content="Official portfolio of Ashishxmani. DevOps Engineer, Guitarist, and Entrepreneur. Explore my projects, music, and services.">
    <meta name="keywords"
        content="Ashishxmani, DevOps, Guitarist, Entrepreneur, Cloud Computing, Music Producer, Portfolio">
    <meta name="author" content="Ashishxmani">
    <meta name="robots" content="index, follow">

    <!-- Canonical URL -->
    <link rel="canonical" href="https://ashishxmani.online/">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://ashishxmani.online/">
    <meta property="og:title" content="Ashishxmani — Guitarist, DevOps Engineer, Entrepreneur">
    <meta property="og:description"
        content="I design systems, build businesses, and create music. Explore my world of technology, creativity, and innovation.">
    <meta property="og:image" content="https://ashishxmani.online/assets/images/og-image.jpg">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://ashishxmani.online/">
    <meta property="twitter:title" content="Ashishxmani — Guitarist, DevOps Engineer, Entrepreneur">
    <meta property="twitter:description"
        content="I design systems, build businesses, and create music. Explore my world of technology, creativity, and innovation.">
    <meta property="twitter:image" content="https://ashishxmani.online/assets/images/og-image.jpg">

    <!-- Google AdSense -->
    <script async
        src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-YOUR_ADSENSE_ID_HERE"
        crossorigin="anonymous"></script>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;800&family=Oswald:wght@400;500;700;900&display=swap"
        rel="stylesheet">

    <!-- Tailwind CSS (CDN) -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'space-black': '#0a0a0a',
                        'void-black': '#000000',
                        'neon-blue': '#00f3ff',
                        'neon-purple': '#bd00ff',
                        'neon-lime': '#ccff00',
                        'hot-pink': '#ff0099',
                        'white-glare': '#ffffff',
                        'silver': '#e5e5e7',
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                        oswald: ['Oswald', 'sans-serif'],
                    },
                    animation: {
                        'glitch-1': 'glitch-anim-1 2s infinite linear alternate-reverse',
                        'glitch-2': 'glitch-anim-2 3s infinite linear alternate-reverse',
                        'pulse-fast': 'pulse 1s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                    }
                }
            }
        }
    </script>

    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/css/style.css">

    <!-- Three.js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/three.js/r128/three.min.js"></script>
</head>

<body class="bg-void-black text-white-glare overflow-x-hidden">

    <!-- Noise Overlay -->
    <div class="noise-overlay"></div>

    <!-- Custom Cursor -->
    <div class="cursor-dot" id="cursor-dot"></div>

    <!-- Navigation -->
    <nav class="fixed top-0 left-0 w-full z-50 p-6 mix-blend-exclusion">
        <div class="flex justify-between items-center max-w-7xl mx-auto">
            <a href="index.php"
                class="text-xl font-bold font-oswald tracking-tighter hover:text-neon-lime transition-colors">ASHISHXMANI</a>
            <div class="hidden md:flex gap-8 text-sm font-bold tracking-widest uppercase">
                <a href="index.php" class="hover:text-neon-lime transition-colors">Home</a>
                <a href="devops.php" class="hover:text-neon-blue transition-colors">DevOps</a>
                <a href="music.php" class="hover:text-neon-purple transition-colors">Music</a>
                <a href="blog.php" class="hover:text-white-glare transition-colors">Blog</a>
                <a href="contact.php" class="hover:text-hot-pink transition-colors">Contact</a>
            </div>
        </div>
    </nav>