<?php include 'includes/header.php'; ?>

<!-- DEVOPS SECTION -->
<section id="devops" class="section relative min-h-screen flex items-center justify-center p-6 bg-space-black pt-24">
    <div class="max-w-7xl w-full grid grid-cols-1 lg:grid-cols-2 gap-12 items-center relative z-10">
        <!-- 3D Terminal Container -->
        <div id="terminal-container"
            class="h-[500px] relative order-2 lg:order-1 border border-neon-blue/20 rounded-lg overflow-hidden bg-black/50 backdrop-blur-sm">
            <!-- Terminal Canvas injected here -->
        </div>

        <div class="order-1 lg:order-2">
            <h1
                class="text-6xl font-black font-oswald text-transparent bg-clip-text bg-gradient-to-r from-neon-blue to-white-glare mb-6">
                DevOps Engineering
            </h1>
            <p class="text-lg mb-6 text-silver">
                I architect, automate, and optimize cloud infrastructure to help businesses scale with confidence.
                From containerization to continuous deployment, I build robust pipelines.
            </p>

            <h3 class="text-xl text-silver mb-4 uppercase tracking-widest">Tech Stack</h3>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
                <!-- Tech Items -->
                <div
                    class="glass-box p-4 rounded-xl text-center hover:glow-blue transition-all cursor-pointer group border border-transparent hover:border-neon-blue">
                    <div class="text-3xl mb-2 group-hover:animate-pulse">🐧</div>
                    <div class="text-sm font-bold">Linux</div>
                </div>
                <div
                    class="glass-box p-4 rounded-xl text-center hover:glow-blue transition-all cursor-pointer group border border-transparent hover:border-neon-blue">
                    <div class="text-3xl mb-2 group-hover:animate-pulse">🐳</div>
                    <div class="text-sm font-bold">Docker</div>
                </div>
                <div
                    class="glass-box p-4 rounded-xl text-center hover:glow-blue transition-all cursor-pointer group border border-transparent hover:border-neon-blue">
                    <div class="text-3xl mb-2 group-hover:animate-pulse">☸️</div>
                    <div class="text-sm font-bold">K8s</div>
                </div>
                <div
                    class="glass-box p-4 rounded-xl text-center hover:glow-blue transition-all cursor-pointer group border border-transparent hover:border-neon-blue">
                    <div class="text-3xl mb-2 group-hover:animate-pulse">☁️</div>
                    <div class="text-sm font-bold">AWS</div>
                </div>
            </div>

            <!-- Experience Timeline -->
            <div class="mt-16 border-t border-white/10 pt-12">
                <h3 class="text-2xl font-bold text-white mb-8 font-oswald text-center lg:text-left">Work Experience</h3>
                <div class="space-y-8 relative border-l-2 border-neon-blue/30 ml-3 pl-8">
                    <!-- Job 1 -->
                    <div class="relative group">
                        <div
                            class="absolute -left-[41px] top-1 w-5 h-5 rounded-full bg-space-black border-2 border-neon-blue group-hover:bg-neon-blue transition-colors">
                        </div>
                        <h4 class="text-white font-bold text-lg">Senior DevOps Engineer</h4>
                        <div class="text-neon-blue text-sm mb-2">TechCorp Solutions • 2021 - Present</div>
                        <p class="text-silver/70 text-sm">
                            Lead the migration of legacy monoliths to microservices on AWS EKS. Implemented GitOps
                            workflows with ArgoCD, reducing deployment time by 40%.
                        </p>
                    </div>
                    <!-- Job 2 -->
                    <div class="relative group">
                        <div
                            class="absolute -left-[41px] top-1 w-5 h-5 rounded-full bg-space-black border-2 border-white/30 group-hover:border-neon-blue transition-colors">
                        </div>
                        <h4 class="text-white font-bold text-lg">Cloud Infrastructure Specialist</h4>
                        <div class="text-silver text-sm mb-2">CloudSafe Inc. • 2018 - 2021</div>
                        <p class="text-silver/70 text-sm">
                            Managed multi-region AWS infrastructure using Terraform. Automated security compliance
                            checks and established disaster recovery protocols.
                        </p>
                    </div>
                </div>
            </div>

            <div class="mt-8">
                <a href="contact.php" class="btn-crazy inline-block text-base px-8 py-3">Hire Me</a>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>