<?php include 'includes/header.php'; ?>

<!-- CONTACT SECTION -->
<section id="contact" class="section relative min-h-screen flex items-center justify-center p-6 bg-space-black pt-24">
    <div class="max-w-7xl w-full text-center relative z-10">
        <h1 class="glitch text-5xl md:text-7xl font-black font-oswald text-white-glare mb-6" data-text="Let's Create">
            Let's Create
        </h1>
        <p class="text-xl max-w-2xl mx-auto mb-12 text-silver">
            DevOps expertise, music collaboration, or business opportunities.
        </p>

        <div
            class="max-w-xl mx-auto bg-white/5 p-8 rounded-2xl border border-white/10 backdrop-blur-md shadow-2xl shadow-purple-900/20">
            <form id="contact-form" class="space-y-4 text-left">
                <div>
                    <label class="block text-sm text-silver mb-1">Name</label>
                    <input type="text" name="name" required
                        class="w-full bg-black/50 border border-white/10 rounded-lg p-3 text-white focus:border-neon-blue focus:outline-none transition-all placeholder-white/20"
                        placeholder="John Doe">
                </div>
                <div>
                    <label class="block text-sm text-silver mb-1">Email</label>
                    <input type="email" name="email" required
                        class="w-full bg-black/50 border border-white/10 rounded-lg p-3 text-white focus:border-neon-blue focus:outline-none transition-all placeholder-white/20"
                        placeholder="john@example.com">
                </div>
                <div>
                    <label class="block text-sm text-silver mb-1">Message</label>
                    <textarea name="message" rows="4" required
                        class="w-full bg-black/50 border border-white/10 rounded-lg p-3 text-white focus:border-neon-blue focus:outline-none transition-all placeholder-white/20"
                        placeholder="Tell me about your project..."></textarea>
                </div>
                <button type="submit" class="btn-crazy w-full mt-4 cursor-pointer">Send Message</button>
            </form>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>