<?php include 'includes/header.php'; ?>

<!-- BLOG SECTION -->
<section id="blog" class="section relative min-h-screen p-6 bg-void-black pt-32">
    <div class="max-w-7xl w-full mx-auto relative z-10">
        <h1 class="glitch text-5xl md:text-7xl font-black font-oswald text-white-glare mb-12 text-center"
            data-text="Build & Deploy">
            Build & Deploy
        </h1>

        <p class="text-center text-silver max-w-2xl mx-auto mb-16">
            Insights on DevOps, Cloud Architecture, and the intersection of code and music.
        </p>

        <?php
        $posts_file = 'data/posts.json';
        $posts = file_exists($posts_file) ? json_decode(file_get_contents($posts_file), true) : [];
        if (empty($posts)) {
            echo '<p class="text-center text-silver col-span-3">No posts yet. Login to Admin Panel to write one!</p>';
        } else {
            // Sort by ID descending (newest first)
            usort($posts, function ($a, $b) {
                return $b['id'] - $a['id']; });

            echo '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">';
            foreach ($posts as $post) {
                ?>
                <!-- Dynamic Article -->
                <article class="glass-box p-6 rounded-2xl hover:border-neon-blue transition-all group flex flex-col h-full">
                    <div class="h-48 bg-gray-600/30 rounded-lg mb-6 flex items-center justify-center text-6xl">
                        <?php echo htmlspecialchars($post['emoji']); ?>
                    </div>
                    <h2
                        class="text-2xl font-bold font-oswald mb-3 text-white group-hover:text-neon-blue transition-colors line-clamp-2">
                        <?php echo htmlspecialchars($post['title']); ?>
                    </h2>
                    <div class="text-xs text-gray-500 mb-2 font-mono"><?php echo htmlspecialchars($post['date']); ?></div>
                    <p class="text-silver/80 text-sm mb-6 line-clamp-3 flex-grow">
                        <?php echo htmlspecialchars(substr($post['content'], 0, 150)) . '...'; ?>
                    </p>
                    <div class="mt-auto">
                        <a href="article.php?id=<?php echo $post['id']; ?>"
                            class="text-neon-lime text-xs font-bold uppercase tracking-widest hover:underline">Read Article
                            →</a>
                    </div>
                </article>
            <?php
            }
            echo '</div>';
        }
        ?>

        <!-- AdSense Placeholder In-Feed -->
        <div class="mt-12 p-8 border border-dashed border-white/20 rounded-lg text-center text-silver/30">
            [Advertisement Placeholder]
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>