<?php
include 'includes/header.php';

$id = isset($_GET['id']) ? $_GET['id'] : null;
$posts = json_decode(file_get_contents('data/posts.json'), true);
$post = null;

foreach ($posts as $p) {
    if ($p['id'] == $id) {
        $post = $p;
        break;
    }
}

if (!$post) {
    echo "<div class='min-h-screen flex items-center justify-center text-white text-2xl'>Post not found.</div>";
    include 'includes/footer.php';
    exit;
}
?>

<article class="min-h-screen pt-32 pb-20 px-6 bg-void-black">
    <div class="max-w-3xl mx-auto relative z-10">
        <a href="blog.php" class="text-silver/50 hover:text-white mb-8 inline-block text-sm">← Back to Blog</a>

        <div class="text-center mb-12">
            <div class="text-8xl mb-6 animate-pulse-fast inline-block">
                <?php echo $post['emoji']; ?>
            </div>
            <h1 class="text-4xl md:text-6xl font-black font-oswald text-white mb-4 leading-tight">
                <?php echo htmlspecialchars($post['title']); ?>
            </h1>
            <div class="text-silver/50 font-mono text-sm">Published on
                <?php echo $post['date']; ?>
            </div>
        </div>

        <div class="text-silver leading-relaxed text-lg space-y-6 prose prose-invert prose-lg max-w-none">
            <?php echo nl2br(htmlspecialchars($post['content'])); ?>
        </div>

        <!-- AdSense Placeholder (Article Bottom) -->
        <div class="mt-16 p-8 border border-dashed border-white/20 rounded-lg text-center text-silver/30 bg-white/5">
            [Advertisement Placeholder]
        </div>

        <div class="mt-12 pt-12 border-t border-white/10 text-center">
            <h3 class="text-white font-bold mb-4">Share this article</h3>
            <div class="flex gap-4 justify-center">
                <button
                    class="bg-blue-500 text-white px-4 py-2 rounded text-sm font-bold hover:bg-blue-600 transition-colors">Twitter</button>
                <button
                    class="bg-blue-700 text-white px-4 py-2 rounded text-sm font-bold hover:bg-blue-800 transition-colors">Facebook</button>
                <button
                    class="bg-green-600 text-white px-4 py-2 rounded text-sm font-bold hover:bg-green-700 transition-colors">WhatsApp</button>
            </div>
        </div>
    </div>
</article>

<?php include 'includes/footer.php'; ?>