<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    http_response_code(403);
    exit("Unauthorized");
}

$file = '../data/posts.json';
$posts = json_decode(file_get_contents($file), true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'];

    if ($action === 'add') {
        $new_post = [
            'id' => empty($posts) ? 1 : end($posts)['id'] + 1,
            'title' => $_POST['title'],
            'content' => $_POST['content'],
            'emoji' => $_POST['emoji'] ?: '📄',
            'date' => date('Y-m-d')
        ];
        $posts[] = $new_post;
    } elseif ($action === 'delete') {
        $id = $_POST['id'];
        $posts = array_filter($posts, function ($post) use ($id) {
            return $post['id'] != $id;
        });
        $posts = array_values($posts); // Re-index array
    }

    file_put_contents($file, json_encode($posts, JSON_PRETTY_PRINT));
    header("Location: ../admin/dashboard.php");
    exit;
}
?>