<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$posts_file = '../data/posts.json';
$posts = file_exists($posts_file) ? json_decode(file_get_contents($posts_file), true) : [];
$posts = array_reverse($posts); // Newest first
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ashishxmani CMS</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>

<body class="bg-gray-50 text-gray-900 flex min-h-screen">

    <!-- Sidebar -->
    <aside class="w-64 bg-white border-r border-gray-200 hidden md:flex flex-col">
        <div class="h-16 flex items-center px-6 border-b border-gray-200">
            <span class="text-xl font-bold tracking-tight text-orange-500"><i
                    class="fa-brands fa-blogger text-2xl mr-2"></i> Blogger</span>
        </div>
        <nav class="flex-1 overflow-y-auto py-4">
            <a href="#" class="flex items-center px-6 py-3 bg-orange-50 text-orange-600 border-r-4 border-orange-500">
                <i class="fas fa-newspaper w-6"></i>
                <span class="font-medium">Posts</span>
            </a>
            <a href="#"
                class="flex items-center px-6 py-3 text-gray-600 hover:bg-gray-50 hover:text-gray-900 transition-colors">
                <i class="fas fa-chart-bar w-6"></i>
                <span class="font-medium">Stats</span>
            </a>
            <a href="#"
                class="flex items-center px-6 py-3 text-gray-600 hover:bg-gray-50 hover:text-gray-900 transition-colors">
                <i class="fas fa-comment w-6"></i>
                <span class="font-medium">Comments</span>
            </a>
            <a href="#"
                class="flex items-center px-6 py-3 text-gray-600 hover:bg-gray-50 hover:text-gray-900 transition-colors">
                <i class="fas fa-cog w-6"></i>
                <span class="font-medium">Settings</span>
            </a>
        </nav>
        <div class="p-4 border-t border-gray-200">
            <a href="../index.php" target="_blank"
                class="flex items-center px-4 py-2 text-sm text-gray-600 hover:text-gray-900">
                <i class="fas fa-external-link-alt mr-2"></i> View Blog
            </a>
            <a href="logout.php" class="flex items-center px-4 py-2 text-sm text-red-600 hover:text-red-800 mt-2">
                <i class="fas fa-sign-out-alt mr-2"></i> Logout
            </a>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="flex-1 flex flex-col">
        <!-- Header -->
        <header class="h-16 bg-white border-b border-gray-200 flex items-center justify-between px-8">
            <h1 class="text-lg font-semibold text-gray-800">All Posts (<?php echo count($posts); ?>)</h1>
            <button onclick="document.getElementById('newPostModal').classList.remove('hidden')"
                class="bg-orange-500 hover:bg-orange-600 text-white px-4 py-2 rounded-md shadow-sm text-sm font-medium transition-colors">
                <i class="fas fa-plus mr-2"></i> New Post
            </button>
        </header>

        <!-- Content Area -->
        <div class="p-8 overflow-y-auto">
            <!-- Posts List -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                <table class="w-full">
                    <thead class="bg-gray-50 text-gray-500 text-xs uppercase font-medium">
                        <tr>
                            <th class="px-6 py-3 text-left">Title</th>
                            <th class="px-6 py-3 text-left">Author</th>
                            <th class="px-6 py-3 text-left">Date</th>
                            <th class="px-6 py-3 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php foreach ($posts as $post): ?>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4">
                                    <div class="font-medium text-gray-900 text-base">
                                        <span class="mr-2"><?php echo htmlspecialchars($post['emoji']); ?></span>
                                        <?php echo htmlspecialchars($post['title']); ?>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center">
                                        <div
                                            class="h-8 w-8 rounded-full bg-orange-100 flex items-center justify-center text-orange-600 font-bold text-xs mr-2">
                                            A</div>
                                        <span class="text-sm text-gray-600">Ashish</span>
                                    </div>
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-500">
                                    <?php echo htmlspecialchars($post['date']); ?>
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <form action="../api/blog_handler.php" method="POST"
                                        onsubmit="return confirm('Delete this post?');" class="inline-block">
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="id" value="<?php echo $post['id']; ?>">
                                        <button type="button" class="text-gray-400 hover:text-blue-600 mr-3"><i
                                                class="fas fa-eye"></i></button>
                                        <button type="submit" class="text-gray-400 hover:text-red-600"><i
                                                class="fas fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (empty($posts)): ?>
                            <tr>
                                <td colspan="4" class="px-6 py-12 text-center text-gray-400">
                                    <i class="fas fa-file-alt text-4xl mb-3"></i>
                                    <p>No posts found. Create your first one!</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                </div>
            </div>
        </div>
    </main>

    <!-- New Post Modal -->
    <div id="newPostModal"
        class="hidden fixed inset-0 bg-black/50 z-50 flex items-center justify-center p-4 backdrop-blur-sm">
        <div class="bg-white rounded-lg shadow-2xl w-full max-w-2xl max-h-[90vh] flex flex-col">
            <div class="p-6 border-b border-gray-200 flex justify-between items-center">
                <h2 class="text-xl font-bold text-gray-800">Create New Post</h2>
                <button onclick="document.getElementById('newPostModal').classList.add('hidden')"
                    class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>

            <form action="../api/blog_handler.php" method="POST" class="flex-1 flex flex-col overflow-hidden">
                <input type="hidden" name="action" value="add">
                <div class="p-6 space-y-4 overflow-y-auto">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Title</label>
                        <input type="text" name="title" required
                            class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-orange-500 focus:border-orange-500 outline-none transition-shadow"
                            placeholder="Post Title">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Emoji Icon</label>
                        <input type="text" name="emoji"
                            class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-orange-500 focus:border-orange-500 outline-none transition-shadow"
                            placeholder="e.g. 🚀">
                    </div>
                    <div class="flex-1">
                        <label class="block text-sm font-medium text-gray-700 mb-1">Content</label>
                        <textarea name="content" required rows="10"
                            class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-orange-500 focus:border-orange-500 outline-none transition-shadow font-mono text-sm"
                            placeholder="Write your masterpiece..."></textarea>
                    </div>
                </div>
                <div class="p-6 border-t border-gray-200 bg-gray-50 flex justify-end gap-3">
                    <button type="button" onclick="document.getElementById('newPostModal').classList.add('hidden')"
                        class="px-4 py-2 text-gray-700 hover:text-gray-900 font-medium">Cancel</button>
                    <button type="submit"
                        class="px-6 py-2 bg-orange-500 hover:bg-orange-600 text-white rounded-md font-medium shadow-sm transition-colors">Publish</button>
                </div>
            </form>
        </div>
    </div>

</body>

</html>